package seasar2.sample;

import junit.framework.TestCase;

/**
 * JUnitgiS2UnitgȂjProductModel̒P̃eXg
 */
public class ProductModelTest extends TestCase {

	public ProductModelTest(String arg) {
		super(arg);
	}
	
	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}
	
	/**
	 * iP100~A10ɑ΂čvz1000~ł邱ƂmF
	 */
	public void testCalcTotalPrice() throws Exception{
		ProductModel productModel = new ProductModel();
		productModel.setProductDAO(createMockProductDAO());
		assertEquals(1000, productModel.calcTotalPrice("001", 10));		
	}

	/**
	 * iP100~A0ɑ΂IllegalArgumentExceptionX[邱ƂmF
	 */
	public void testIllegalCalcTotalPrice() throws Exception{
		try{
			ProductModel productModel = new ProductModel();
			productModel.setProductDAO(createMockProductDAO());
			productModel.calcTotalPrice("001", 0);
			fail();
		}catch(IllegalArgumentException e){}
	}
	
	/**
	 * ProductDAÕbNCX^X𐶐B
	 * @return ProductDAÕbNCX^X
	 */
	private ProductDAO createMockProductDAO() {
		ProductDAO productDAO = new ProductDAO(){
		    /**
		     * ɐiP100~ProductCX^XԂ
		     */
			public Product findByPrimaryKey(String productId) {
				Product product = new Product();
				product.setUnitPrice(100);
				return product;
			}
			
		};
		return productDAO;
	}
}
