package example;

import java.util.Properties;

/**
 * t@CAhXf[^ǂݍރIuWFNg𐶐NXB
 */
public class AddressReaderFactory {
    /** ݒt@C */
    private static final String PROPERTY_FILE = "address_manager.properties";

    /** f[^t@C`̐ݒt@CL[ */
    private static final String KEY_FILETYPE = "file.type";

    /** f[^t@C`: CSV */
    private static final String FILETYPE_CSV = "csv";

    /** f[^t@C`: XML */
    private static final String FILETYPE_XML = "xml";

    /** f[^u */
    private static final String DATA_PATH = "C:/eclipse/workspace/s2book-example/data/";

    /**
     * RXgN^B
     */
    private AddressReaderFactory() {
    	// CX^X𐶐Ȃ
    }

    /**
     * f[^t@C`ɍf[^t@C
     * ǂݍރIuWFNg𐶐܂B
     *
     * @return f[^t@CǂݍރIuWFNg
     */
    public static AddressReader createInstance() {
    	Properties properties = Util.loadProperties(PROPERTY_FILE);

    	String fileType = properties.getProperty(KEY_FILETYPE);

        if (FILETYPE_XML.equalsIgnoreCase(fileType)) {
            return new XmlFileAddressReader(DATA_PATH);
        } else if (FILETYPE_CSV.equalsIgnoreCase(fileType)) {
            return new CsvFileAddressReader(DATA_PATH);
        } else {
            throw new UnsupportedFileTypeException(
            		"m̌`ł: " + fileType);
        }
    }
}
