package example;

import java.util.List;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * XML`̃AhXf[^pSAXnhB
 */
public class AddressHandler extends DefaultHandler {
    private AddressData data;

    private StringBuffer sb;

    /** IuWFNgi[List */
    private List result;

    /**
     * IuWFNgi[List󂯎RXgN^B
     *
     * @param result IuWFNgi[List
     */
    public AddressHandler(List result) {
        this.result = result;
        this.sb = new StringBuffer();
    }

    /**
     * @see org.xml.sax.helpers.DefaultHandler#
     *  startElement(java.lang.String, java.lang.String,
     *  java.lang.String, org.xml.sax.Attributes)
     */
    public void startElement(
            String uri, String localName,
            String qName, Attributes attributes) throws SAXException {
        if (qName.equals("address-data")) {
            data = new AddressData();
        }
        sb.setLength(0);
    }

    /**
     * @see org.xml.sax.helpers.DefaultHandler#
     * characters(char[], int, int)
     */
    public void characters(char[] ch, int start, int length)
            throws SAXException {
        sb.append(ch, start, length);
    }

    /**
     * @see org.xml.sax.helpers.DefaultHandler#
     *  endElement(java.lang.String, java.lang.String, java.lang.String)
     */
    public void endElement(
            String uri, String localName, String qName)
            throws SAXException {
        if (qName.equals("address-data")) {
            result.add(data);
        } else if (qName.equals("name")) {
            data.setNameKanji(new String(sb));
        } else if (qName.equals("kana")) {
            data.setNameKana(new String(sb));
        } else if (qName.equals("zip-code")) {
            data.setZipCode(new String(sb));
        } else if (qName.equals("address")) {
            data.setAddress(new String(sb));
        } else if (qName.equals("tel")) {
            data.setTel(new String(sb));
        }
    }
}
