package example;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/**
 * CSV`̃t@CAhXf[^ǂݍ݁AAddressDataList쐬܂B
 */
public class CsvFileAddressReader implements AddressReader {
	/** ؂蕶(R}) */
	private static final String SEPARATOR = ",";

	/** f[^t@C */
	private String fileName = "address.csv";

	/** f[^u */
	private String dataPath;

	/**
     * RXgN^B
     *
     * @param dataPath f[^t@CtH_̃pX ('/'ŏIĂ邱)
     */
    public CsvFileAddressReader(String dataPath) {
    	this.dataPath = dataPath;
    }

    /**
     * t@CǂݍAddressDataList쐬ĕԂ܂B
     * rɋs͖AׂĂ̍š`̂Ƃ܂B
     *
     * @return AddressDataList
     */
    public List read() {
        List result = new ArrayList();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(dataPath + fileName));
            String line;
            while (hasValue(line = reader.readLine())) {
                StringTokenizer tokenizer = new StringTokenizer(line, SEPARATOR);

                result.add(readFromTokenizer(tokenizer));
            }
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            close(reader);
        }
        return result;
    }

    /**
     * TokenizerAhXf[^쐬܂B
     *
     * @param tokenizer AhXf[^܂Tokenizer
     * @return AhXf[^
     */
    private AddressData readFromTokenizer(StringTokenizer tokenizer) {
        AddressData data = new AddressData();
        data.setNameKanji(tokenizer.nextToken().trim());
        data.setNameKana(tokenizer.nextToken().trim());
        data.setZipCode(tokenizer.nextToken().trim());
        data.setAddress(tokenizer.nextToken().trim());
        data.setTel(tokenizer.nextToken().trim());
    	return data;
    }

    /**
     * ̕񂪋󕶎łȂǂ𒲂ׂ܂B
     *
     * @param test ׂ镶
     * @return nullł󕶎łȂtrue
     */
    private boolean hasValue(String test) {
        return (test != null) && (test.length() > 0);
    }

    /**
     * BufferedReader܂B
     * null̏ꍇ͉܂B
     * IOExceptionꍇ̓X^bNg[Xo͂܂B
     *
     * @param reader BufferedReader
     */
    private void close(BufferedReader reader) {
        if (reader != null) {
            try {
                reader.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}
