package example;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/**
 * CSV`̃t@CZf[^ǂݍ݁AAddressDataList쐬܂B
 */
public class AddressFileReader {
    /**
     * RXgN^B
     */
    public AddressFileReader() {
    }

    /**
     * CSVt@CǂݍAddressDataList쐬ĕԂ܂B
     * rɋs͖AׂĂ̍š`̂Ƃ܂B
     *
     * @param fileName t@C̃pX
     * @return AddressDataList
     */
    public List readFile(String fileName) {
        List result = new ArrayList();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(fileName));
            String line;
            while (hasValue(line = reader.readLine())) {
                StringTokenizer tokenizer = new StringTokenizer(line, ",");

                AddressData data = new AddressData();
                data.setNameKanji(tokenizer.nextToken());
                data.setNameKana(tokenizer.nextToken());
                data.setZipCode(tokenizer.nextToken());
                data.setAddress(tokenizer.nextToken());
                data.setTel(tokenizer.nextToken());

                result.add(data);
            }
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            close(reader);
        }
        return result;
    }

    /**
     * ̕񂪋󕶎łȂǂ𒲂ׂ܂B
     *
     * @param test ׂ镶
     * @return nullł󕶎łȂtrue
     */
    private boolean hasValue(String test) {
        return (test != null) && (test.length() > 0);
    }

    /**
     * BufferedReader܂B
     * null̏ꍇ͉܂B
     * IOExceptionꍇ̓X^bNg[Xo͂܂B
     *
     * @param reader BufferedReader
     */
    private void close(BufferedReader reader) {
        if (reader != null) {
            try {
                reader.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}
