/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.tx;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.aopalliance.intercept.MethodInterceptor;
import org.seasar.framework.exception.SIllegalArgumentException;

public abstract class AbstractTxInterceptor
implements MethodInterceptor {
    private TransactionManager transactionManager_;
    private List txRules_ = new ArrayList();
    static /* synthetic */ Class class$java$lang$Throwable;

    public AbstractTxInterceptor(TransactionManager transactionManager) {
        this.transactionManager_ = transactionManager;
    }

    public final TransactionManager getTransactionManager() {
        return this.transactionManager_;
    }

    public final boolean hasTransaction() throws SystemException {
        return this.transactionManager_.getStatus() != 6;
    }

    public final Transaction getTransaction() throws SystemException {
        return this.transactionManager_.getTransaction();
    }

    public final void begin() throws NotSupportedException, SystemException {
        this.transactionManager_.begin();
    }

    public final void commit() throws SecurityException, IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        this.transactionManager_.commit();
    }

    public final void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (this.hasTransaction()) {
            this.transactionManager_.rollback();
        }
    }

    public final Transaction suspend() throws SystemException {
        return this.transactionManager_.suspend();
    }

    public final void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.transactionManager_.resume(transaction);
    }

    public final boolean complete(Throwable t) throws SecurityException, IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        for (int i = 0; i < this.txRules_.size(); ++i) {
            TxRule rule = (TxRule)this.txRules_.get(i);
            if (!rule.isAssignableFrom(t)) continue;
            return rule.complete();
        }
        this.rollback();
        return false;
    }

    public final void addCommitRule(Class exceptionClass) {
        this.txRules_.add(new TxRule(exceptionClass, true));
    }

    public final void addRollbackRule(Class exceptionClass) {
        this.txRules_.add(new TxRule(exceptionClass, false));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TxRule {
        private Class exceptionClass_;
        private boolean commit_;

        public TxRule(Class exceptionClass, boolean commit) {
            if (!(class$java$lang$Throwable == null ? (class$java$lang$Throwable = AbstractTxInterceptor.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(exceptionClass)) {
                throw new SIllegalArgumentException("ESSR0365", new Object[]{exceptionClass.getName()});
            }
            this.exceptionClass_ = exceptionClass;
            this.commit_ = commit;
        }

        public boolean isAssignableFrom(Throwable t) {
            return this.exceptionClass_.isAssignableFrom(t.getClass());
        }

        public boolean complete() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
            if (this.commit_) {
                AbstractTxInterceptor.this.commit();
            } else {
                AbstractTxInterceptor.this.rollback();
            }
            return this.commit_;
        }
    }
}

